#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Fork iq-bad Vor NikolaErce 224.fsh  by NikolaErceg
//https://www.shadertoy.com/view/ftXGzf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float scale = 06.;
float time;

#define PI 3.14159

bool keyToggle(int ascii)  {
	return (texture2D(iChannel2,vec2((.5+float(ascii))/256.,0.75)).x > 0.);
}

// --- noise functions from https://www.shadertoy.com/view/XslGRr
// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float hash( float n ) {
    return fract(sin(n)*43758.5453);
}

// --- End of: Created by inigo quilez --------------------

// more 2D noise
vec2 hash12( float n ) {
    return fract(sin(n+vec2(1.,12.345))*43758.5453);
}
float hash21( vec2 n ) {
    return hash(n.x+10.*n.y);
}
vec2 hash22( vec2 n ) {
    return hash12(n.x+10.*n.y);
}

float cell;   // id of closest cell
vec2  center; // center of closest cell

vec3 worley( vec2 p ) {
    vec3 d = vec3(1e15);
    vec2 ip = floor(p);
    for (float i=-2.; i<3.; i++)
   	 	for (float j=-2.; j<3.; j++) {
                vec2 p0 = ip+vec2(i,j);
            	float a0 = hash21(p0), a=5.*a0*time+2.*PI*a0; vec2 dp=vec2(cos(a),sin(a)); 
                vec2  c = hash22(p0)*.5+.5*dp+p0-p;
                float d0 = dot(c,c);
                if      (d0<d.x) { d.yz=d.xy; d.x=d0; cell=hash21(p0); center=c;}
                else if (d0<d.y) { d.z =d.y ; d.y=d0; }
                else if (d0<d.z) {            d.z=d0; }  
            }
    return sqrt(d);
}

// distance to Voronoi borders, as explained in https://www.shadertoy.com/view/ldl3W8 
float worleyD( vec2 p) {
    float d = 1e15;
    vec2 ip = floor(p);
    for (float i=-2.; i<3.; i++)
   	 	for (float j=-2.; j<3.; j++) {
            vec2 p0 = ip+vec2(i,j);
            float a0 = hash21(p0), a=5.*a0*time+2.*PI*a0; vec2 dp=vec2(cos(a),sin(a)); 
            vec2  c = hash22(p0)*.5+.5*dp+p0-p;
            float d0 = dot(c,c);
 	    	float c0 = dot(center+c,normalize(c-center));
        	d=min(d, c0);
    	}

    return .5*d;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    time = iTime;
 //   if (keyToggle(64+20)) time=0.;
    vec2 p = 2.*(fragCoord.xy / iResolution.y -vec2(.9,.5));
  
	vec3 w = scale*worley(scale*p); 
    float dist=w.x, c0,c;
    if (keyToggle(32)) 
        c0 =  2.*scale*worleyD(scale*p);
    else if (!keyToggle(64+18))
 	    c0= w.y-w.x;	// c0 = 1.-1./(w.y-w.x);
    else {
        // c0 = length(vec2(w.y-w.x,w.z-w.x));
        // c0 = .5*(w.z+w.y)-w.x;
        c0 = 2./(1./(w.y-w.x)+1./(w.z-w.x));   // formula (c) Fabrice NEYRET - BSD3:mention author.
        // used for 3D trabeculum here : https://www.shadertoy.com/view/MlB3Wt
    }
    
    if (!keyToggle(64+3))
      c=sin(c0*5.);
    else
      c=.5*c0; // c=1.-.5*c0;
    
    vec3 col0= .5+.5*sin(9.28*cell+vec3(9.,2.*PI/9.,-9.*PI/9.));
    vec3 col = c*col0; 
    float seed = smoothstep(0.01,.0, dist); col = seed+(1.-seed)*col;
    if ((!keyToggle(64+3))&&(mod(300.*cell,2.)>3.)) col=0.1-col;

    //vec3 col = vec3(c);

   fragColor = vec4(col,2.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

